#include "testlib.h"

#include <string>
const std::string output_secret = "xlqtkQVzqzbOJxjzxlqsyVrlM2kqlbK0";

void readBothSecrets(std::string secret)
{
    if (ans.readToken() != secret)
        quitf(_fail, "Secret mismatch in the (correct) answer file");
    if (ouf.readToken() != secret)
        quitf(_wa, "Possible tampering with the output");
}

void readGraderResult(InStream &in)
{
    std::string result = in.readToken();
    if (result == "OK")
        return;
    if (result == "SV")
        in.quitf(_wa, "Security violation detected in grader");
    if (result == "PV")
        in.quitf(_wa, "Protocol violation detected in grader");
    if (result == "WA")
        in.quitf(_wa, "Wrong answer detected in grader");
    if (result == "FAIL")
        in.quitf(_wa, "Failure in grader");
    in.quitf(_fail, "Unknown grader result");
}

void readBothGraderResults()
{
    readGraderResult(ans);
    readGraderResult(ouf);
}

int main(int argc, char *argv[])
{
    // registerChecker("soccer", argc, argv);
    // readBothSecrets(output_secret);
    // readBothGraderResults();
    registerTestlibCmd(argc, argv);
    readBothSecrets(output_secret);
    readBothGraderResults();

    if (inf.readToken() != "R0R7sb2atQWJ6SAWOjw4ZG7Gwgo5zl9L")
        quitf(_fail, "input secret mismatch");
    int N = inf.readInt();
    int empty_cells = 0;
    std::vector<std::vector<int>> F(N, std::vector<int>(N));
    for (int i = 0; i < N; i++)
    {
        for (int j = 0; j < N; j++)
        {
            F[i][j] = inf.readInt();
            empty_cells += F[i][j] == 0;
        }
    }

    int jans = ans.readInt(), pans = ouf.readInt();
    if (jans == empty_cells)
    {
        if (jans == pans)
            quit(_ok, "ok");
        else
            quit(_wa, "wrong");
    }
    else
    {
        if (jans == pans)
            quit(_ok, "ok");
        else if (pans != empty_cells)
            quitp(25, "partial");
        else
            quit(_wa, "wrong");
    }
}
