#include <cstdlib>
#include <iostream>
#include <fstream>
#include <vector>

namespace std
{
    std::ifstream fin("input");
    std::ofstream fout("score.txt");
}

int main()
{
    int n, nguess = 0;
    std::fin >> n;
    std::vector<int> nums(n);
    for (int i = 0; i < n; i++)
    {
        std::fin >> nums[i];
    }

    while (!std::cin.eof())
    {
        std::string cmd;
        std::cin >> cmd;
        if (cmd == "get_num")
        {
            std::cout << n << std::endl << std::flush;
        }
        else if (cmd == "guess")
        {
            nguess++;
            int index, val;
            std::cin >> index >> val;
            if (!(0 <= index && index < n))
            {
            	std::fout << 0;
            	std::cerr << "`index` must in [0, n)!";
            	return 0;
            }

            if (val < nums[index])
            {
                std::cout << -1 << std::endl << std::flush;
            }
            else if (val > nums[index])
            {
                std::cout << 1 << std::endl << std::flush;
            }
            else
            {
                std::cout << 0 << std::endl << std::flush;
            }
        }
        else if (cmd == "submit")
        {
            bool wrongAnswer = false;
            for (int i = 0; i < n; i++)
            {
                int x;
                std::cin >> x;
                
                if (x != nums[i] && !wrongAnswer)
                {
                    wrongAnswer = true;
                    std::fout << 0;
                    std::cerr << "First differ on the " << i << "-th number!";
                    return 0;
                }
            }
            
            if (!wrongAnswer)
            {
            	std::fout << std::max(std::min(100.0, (950.0 - ((double)nguess / n - 100.0)) / 950.0 * 100.0), 0.0);
                std::cerr << "nguess = " + std::to_string(nguess);
                return 0;
            }
        }
        else
        {
            std::fout << 0;
            std::cerr << "Invalid command `" << cmd << "`!";
            return 0;
        }
    }
}
